//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls 1.0

import wesual.data.Core 1.0

BaseStringEditor {
    text : (document && document[property]) ? document[property] : ""
    onEditingFinished : {
        try {
            // check if there were text changes in the document
            if (document[property] !== text) {
                document.beginRecordChanges();
                document[property] = text;
                document.endRecordChanges();
            }
        } catch (e) {}
    }
}
